/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CRuntime.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CRuntime_h	// [
#define Included_CRuntime_h

#include "pgpClassesConfig.h"

#if defined(PGP_DRIVER98) || defined(PGP_DRIVERNT)

// Not in PGP namespace.

extern "C" 
{
	void * _cdecl	malloc(size_t size);
	void _cdecl		free(void *memBlock);
	void * _cdecl	realloc(void *oldBlock, size_t size);
	void * _cdecl	memmove(void *dest, const void *src, size_t count);

	int _cdecl	tolower(int c);
	int _cdecl	toupper(int c);

	int _cdecl	strncmp(const char *string1, const char *string2, 
		size_t count);
	int _cdecl	_stricmp(const char *string1, const char *string2);
	int _cdecl	_strnicmp(const char *string1, const char *string2, 
		size_t count);

	char * _cdecl	strncat(char *strDest, const char *strSource, 
		size_t count);
	char * _cdecl	strncpy(char *strDest, const char *strSource, 
		size_t count);

	char * _cdecl	strstr(const char *string, const char *strCharSet);

	int _cdecl	sprintf(char *buffer, const char *format, ...);
	int _cdecl	_snprintf(char *buffer, size_t count, 
		const char *format, ...);

	int _cdecl	vsprintf(char *buffer, const char *format, va_list argptr);
	int _cdecl	_vsnprintf(char *buffer, size_t count, const char *format, 
		va_list argptr);

	int _cdecl	_CrtDbgReport(int nRptType, const char	*szFile, int nLine, 
		const char *szModule, const char *szFormat, ...);
}

#endif	// PGP_DRIVER98 || PGP_DRIVERNT

#endif	// ] Included_CRuntime_h
